<?php

//------------------------------------ Validation File ---------------------------------------
function validateMime(array $file, array $allowedTypes): bool {
    // Pastikan file memiliki struktur yang benar dan tidak error
// var_dump($file,$allowedTypes);die;
    if (
        !isset($file['tmp_name'], $file['name'], $file['error'], $file['size']) ||
        $file['error'] !== UPLOAD_ERR_OK ||
        $file['size'] === 0
    ) {
        return false;
    }

    $tmpPath   = $file['tmp_name'];
    $filename  = $file['name'];
    $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

    // var_dump($extension,$allowedTypes);die;
    // Jika ekstensi tidak diizinkan
    if (!array_key_exists($extension, $allowedTypes)) {
        return false;
    }

    // Ambil MIME type dari file sebenarnya
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mime  = finfo_file($finfo, $tmpPath);
    finfo_close($finfo);

    // Debug: tampilkan MIME jika perlu
    // echo "Ekstensi: $extension | MIME: $mime";

    // Validasi MIME
    return in_array($mime, (array) $allowedTypes[$extension], true);
}


function getAllowedMimeTypes(array $categories): array {
    $mimeTypes = [
        'img' => [
            'jpg'  => ['image/jpeg', 'image/jpg'],
            'jpeg' => ['image/jpeg'],
            'png'  => ['image/png'],
            'gif'  => ['image/gif'],
            'webp' => ['image/webp'],
            'bmp'  => ['image/bmp'],
            'svg'  => ['image/svg+xml'],
        ],
        'pdf' => [
            'pdf' => ['application/pdf'],
        ],
        'doc' => [
            'doc'  => ['application/msword'],
            'docx' => ['application/vnd.openxmlformats-officedocument.wordprocessingml.document'],
        ],
        'xls' => [
            'xls'  => ['application/vnd.ms-excel'],
            'xlsx' => ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'],
        ],
        'csv' => [
            'csv' => [
                'text/csv',
                'application/csv',
                'application/vnd.ms-excel',
                'text/plain',
                'application/octet-stream',
            ],
        ],
        'txt' => [
            'txt' => ['text/plain'],
        ],
        'zip' => [
            'zip' => ['application/zip', 'application/x-zip-compressed'],
        ],
    ];

    $result = [];

    foreach ($categories as $cat) {
        if (isset($mimeTypes[$cat])) {
            foreach ($mimeTypes[$cat] as $ext => $mimes) {
                $result[$ext] = $mimes;
            }
        }
    }

    return $result;
}




//-------------------------------------------- POST DATA ----------------------------------------------

function forwardPostData(string $targetUrl, array $data = [], string $from = ''): void {
    if (empty($data)) {
        $data = $_POST;
    }

    // Ambil referer jika $from kosong
    if ($from === '' && isset($_SERVER['HTTP_REFERER'])) {
        $from = $_SERVER['HTTP_REFERER'];
    }

    // Kirim juga ke halaman tujuan sebagai _from
    if ($from !== '') {
        $data['_from'] = $from;
    }

    echo '<form id="autoPostForm" method="POST" action="' . htmlspecialchars($targetUrl) . '">';
    foreach ($data as $key => $value) {
        echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
    }
    echo '</form>';

    echo '<script>document.getElementById("autoPostForm").submit();</script>';
    exit;
}

//------------------------------------ Move File -----------------------------------

function moveCompanyFile(string $fileInputName, string $targetDir, array $allowedTypes, ?string $defaultFile = null): ?string {
    // Periksa apakah ada file yang diupload
    if (!isset($_FILES[$fileInputName]) || empty($_FILES[$fileInputName]['name'])) {
        // Jika tidak ada file, kembalikan file default
        return $defaultFile;
    }

    $file = $_FILES[$fileInputName];

    // Validasi MIME
    if (!validateMime($file, $allowedTypes)) {
        setAlert('danger', 'File tidak valid atau tipe file tidak diizinkan.');
        return $defaultFile;
    }

    $filename = basename($file['name']);
    $targetFile = rtrim($targetDir, '/') . '/' . $filename;
    var_dump($targetFile);
    // Pindahkan file
    if (move_uploaded_file($file['tmp_name'], $targetFile)) {
        return $targetFile;
    } else {
        setAlert('danger', 'Gagal mengunggah file.');
        return $defaultFile;
    }
}

//-------------------------------- Redirect Login -----------------------------------


function verivikasiLogin(){
    $adminData = sessionGetObjectAdmin();

    $admin = $adminData[0]; // Jika memang array berisi 1 data
    $em = $admin['EMAIL'];
    $passHash = $admin['PASSWORD']; // hashed password

    $login = sessionGetLogin();
    $password = $login['PASSWORD'];
    $email = $login['EMAIL'];


    if ($email === $em && password_verify($password, $passHash)) {
        return true;
    } else {
        return false;
    }
}
?>