<?php
include_once '../../Control/urlController.php';

$aksi = $_POST['aksi'];
$index = $_POST['invoice'];
$notes = $_POST['keterangan'];

$target_dir = "../pages/html/img/";
$allowedTypes = getAllowedMimeTypes(['img']);  // Izinkan hanya file gambar

$data = sessionGetObjectInvoices();
$invoiceData = $data[$index - 1];

// Ambil TTD default dari object atau array
$ttdDefault = is_object($invoiceData) ? $invoiceData->getTtd() : $invoiceData['TTD'];

// Upload dan validasi file TTD
$ttd = moveCompanyFile('ttdImage', $target_dir, $allowedTypes, $ttdDefault);

// Pastikan invoice berbentuk object
if (is_object($invoiceData)) {
    $invoice = $invoiceData;
} else {
    $invoice = new Invoice(
        $invoiceData['ID'],
        $invoiceData['KODE'],
        $invoiceData['DATE'],
        $invoiceData['CUSTOMER_ID'],
        $invoiceData['DEADLINE'],
        $invoiceData['NOTES'],
        $invoiceData['TTD']
    );
}

// Update invoice ke database
$updateSuccess = updateInvoice(
    $invoice->getId(),
    $invoice->getCustomerId(),
    $invoice->getDate(),
    $invoice->getKode(),
    $invoice->getDeadline(),
    $notes,
    $ttd
);

if ($updateSuccess) {
    // Simpan object invoice yang sudah diperbarui ke session
    $data[$index - 1] = new Invoice(
        $invoice->getId(),
        $invoice->getKode(),
        $invoice->getDate(),
        $invoice->getCustomerId(),
        $invoice->getDeadline(),
        $notes,
        $ttd
    );
    sessionSetObjectInvoices(array_values($data));
} else {
    setAlert('danger', 'Gagal menyimpan data invoice.');
}

// Generate PDF
$kodeInvoice = is_object($invoice) ? $invoice->getKode() : 'Invoice_L001';
generatePDF(__DIR__ . '/printInvoice.php?index=' . $index, $kodeInvoice, $aksi !== 'download');

?>
