-- Tabel admin
CREATE TABLE admin (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    EMAIL VARCHAR(100) NOT NULL UNIQUE,
    PASSWORD VARCHAR(255) NOT NULL,
    reset_token VARCHAR(255),
    token_expire DATETIME
);

-- Tabel company
CREATE TABLE company (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    NAMA_PERUSAHAAN VARCHAR(255),
    ALAMAT VARCHAR(255),
    KOTA VARCHAR(100),
    PROVINSI VARCHAR(100),
    KODE_POS VARCHAR(20),
    NEGARA VARCHAR(100),
    TELEPON VARCHAR(50),
    EMAIL VARCHAR(100),
    URLLOGO VARCHAR(255)
);

-- Tabel customers
CREATE TABLE customers (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    REF_NO VARCHAR(100) UNIQUE,
    NAME VARCHAR(255),
    EMAIL VARCHAR(100),
    TELEPON VARCHAR(50),
    ALAMAT VARCHAR(255)
);

-- Tabel suppliers
CREATE TABLE suppliers (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    REF_NO VARCHAR(100) UNIQUE,
    NAME VARCHAR(255)
);

-- Tabel items
CREATE TABLE items (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    REF_NO VARCHAR(100) UNIQUE,
    NAME VARCHAR(255),
    PRICE DOUBLE
);

-- Tabel invoice
CREATE TABLE invoice (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    KODE VARCHAR(100) UNIQUE,
    DATE DATE,
    CUSTOMER_ID INT,
    NOTES TEXT,
    DEADLINE DATE,
    TTD VARCHAR(255),
    FOREIGN KEY (CUSTOMER_ID) REFERENCES customers(ID) ON DELETE SET NULL
);

-- Tabel iteminv
CREATE TABLE iteminv (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    INVOICE_ID INT,
    ITEM_ID INT,
    QTY INT,
    PRICE DOUBLE,
    TOTAL DOUBLE,
    FOREIGN KEY (INVOICE_ID) REFERENCES invoice(ID) ON DELETE CASCADE,
    FOREIGN KEY (ITEM_ID) REFERENCES items(ID) ON DELETE SET NULL
);

-- Tabel items_customers
CREATE TABLE items_customers (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    Customer INT,
    Harga INT,
    FOREIGN KEY (Customer) REFERENCES customers(ID) ON DELETE CASCADE
);

-- Tabel payment
CREATE TABLE payment (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    KODE VARCHAR(50) UNIQUE,
    DATE DATE,
    NOMINAL DOUBLE,
    ID_INVOICE INT,
    NOTES TEXT,
    FOREIGN KEY (ID_INVOICE) REFERENCES invoice(ID) ON DELETE SET NULL
);

-- Tabel pic
CREATE TABLE pic (
    ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
    NAMA VARCHAR(255),
    JABATAN VARCHAR(100),
    NOMOR VARCHAR(20),
    EMAIL VARCHAR(255),
    STATUS TINYINT(1) DEFAULT 0
);
